/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.kawakubo;

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 *
 * @author tomoharu
 */
public class RefreshBasketServlet extends HttpServlet {

    @EJB
    private JPASession01Remote jpaBean;
   
    /** 
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {

        List<BasketItemContent> basketItemContents = new ArrayList<BasketItemContent>();

        String[] basketItemIds = request.getParameterValues("id");
        int[] itemIds = new int[basketItemIds.length];
        for (int i = 0; i < itemIds.length; i++) {
            itemIds[i] = Integer.parseInt(basketItemIds[i]);
        }
        String[] allQuantity = request.getParameterValues("quantity");
        int[] quantity = new int[allQuantity.length];
        for (int i = 0; i < quantity.length; i++) {
            quantity[i] = Integer.parseInt(allQuantity[i]);
        }

        jpaBean.updateBasketItems(itemIds, quantity);

        basketItemContents = jpaBean.getBasketItems("");
        request.getSession().setAttribute("basket", basketItemContents);
        List totalCharge = jpaBean.getTotalCharge(basketItemContents);
        request.getSession().setAttribute("totalCharge", totalCharge);

        // ImoshochuShop.jspに遷移する
        RequestDispatcher rd = request.getRequestDispatcher("/ImoshochuShop.jsp");
        rd.forward(request, response);

    } 

    // <editor-fold defaultstate="collapsed" desc="HttpServlet のメソッドです。コードを編集するには、左側の + 符号をクリックしてください。">
    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    } 

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Returns a short description of the servlet.
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
